/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(scaled_gl_FragCoord.xy/resolution)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.

void main(  ) {

	vec3 col = vec3(0.0);
	for (int i=0; i<3; i++)
	{
		vec2 p = scaled_gl_FragCoord.xy / resolution.x - vec2(0.5, 0.5 * resolution.y / resolution.x) + vec2(sin(float(i*i) + 0.5*time), sin(float(i*i*i) + 0.8*time)) * 0.25;
		float l = length(p);
		float a = atan(p.y, p.x);
	
		col.x += pow(1.0 - l, 2.0) + sin(a * 15.0 + 2.0 * time + sin(a * 7.0 + 13.0 * time) * 0.1) * 0.2 + sin(a * 3.0 +7.0 * time) * 0.4;
	
		col.y += col.x * (sin(col.x) * 0.5 + 0.5);
		if (col.x < 0.0) col.y = -col.x;
		col.z += 0.25;
		col *= 0.5;

		col.x = pow (col.y, sin(float(i*i) + 2.5 * time)* 0.5 + 1.5);
		col.y = pow (col.y, sin(float(i*i*i) + 4.3 * time) * 0.5 + 1.5);
		col.z = pow (col.z, sin(float(i*i*i*i) + 3.2 * time) * 0.5 + 1.5);
	}
	gl_FragColor = vec4(col, 1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15

}